import { Subject } from "rxjs";
import { IActionParam, IParam } from "@ibiz-core";

/**
 * 视图props的基类
 */
export interface ViewPropsBase {
  /**
   * 上下文参数(外部传入)
   */
  context?: IParam;

  /**
   * 视图参数(外部传入)
   */
  viewParams?: IParam;

  /**
   * 视图参数(外部传入)
   */
  viewSubject?: Subject<IActionParam>;

  /**
   * 视图打开方式，路由、模态、内嵌，默认为路由方式
   */
  openType?: "ROUTE" | "MODAL" | "EMBED";
}